//=============================================================================
// RecollectionMode.js
// Copyright (c) 2015 rinne_grid
// This plugin is released under the MIT license.
// http://opensource.org/licenses/mit-license.php
//
// Version
// 1.0.0 2015/12/26 公開
// 1.1.0 2016/04/19 回想一覧にサムネイルを指定できるように対応
// 1.1.1 2016/05/03 セーブデータ20番目のスイッチが反映されない不具合を修正
//                  セーブデータ間のスイッチ共有オプション
//                  (share_recollection_switches)を追加
// 1.1.2 2016/05/09 回想用のCGリストのキーを数字から文字列に変更
// 1.1.3 2016/11/23 セーブデータが増えた場合にロード時間が長くなる問題を解消
// 1.1.4 2016/12/23 CG閲覧時にクリック・タップで画像送りができるよう対応
// 1.1.5 2017/01/26 CG・シーンで一部サムネイルが表示されない問題を解消
//=============================================================================

/*:ja
 * @plugindesc 回想モード機能を追加します。
 * @author rinne_grid
 *
 *
 * @help このプラグインには、プラグインコマンドはありません。
 *
 */

//-----------------------------------------------------------------------------
// ◆ プラグイン設定
//-----------------------------------------------------------------------------
// フラグ追加
Scene_Recollection.recollection_event_playing = false;


var rngd_recollection_mode_settings = {
    //---------------------------------------------------------------------
    // ★ 回想モードで再生するBGMの設定をします
    //---------------------------------------------------------------------
    "rec_mode_bgm": {
        "bgm": {
            "name"  : "blank_memories",
            "pan"   : 0,
            "pitch" : 100,
            "volume": 40
        }
    },
    //---------------------------------------------------------------------
    // ★ 回想CG選択ウィンドウの設定を指定します
    //---------------------------------------------------------------------
    "rec_mode_window" : {
        "x": 430,
        "y": 280,
        "recollection_title": "回想模式",
        "str_select_recollection": "觀看回想",
        "str_select_cg": "觀看CG",
        "str_select_back_title": "返回標題"
    },
    //---------------------------------------------------------------------
    // ★ 回想リストウィンドウの設定を指定します
    //---------------------------------------------------------------------
    "rec_list_window": {
        // 1画面に表示する縦の数
        "item_height": 3,
        // 1画面に表示する横の数
        "item_width" : 3,
        // 1枚のCGに説明テキストを表示するかどうか
        "show_title_text": true,
        // タイトルテキストの表示位置(left:左寄せ、center:中央、right:右寄せ）
        "title_text_align": "center",
        // 閲覧したことのないCGの場合に表示するピクチャファイル名
        "never_watch_picture_name": "never_watch_picture",
        // 閲覧したことのないCGのタイトルテキスト
        "never_watch_title_text": "？？？"
    },
    //---------------------------------------------------------------------
    // ★ 回想用のCGを指定します
    //---------------------------------------------------------------------
"rec_cg_set": {
    "1": {
        "title": "【雑兵】敗北",
        "pictures": ["HC1", "HC2", "HC3", "HC4", "HC5", "HC6", "HC7", "HC8", "HC9", "HC10"],
        "common_event_id": 28,
        "switch_id": 128,
        "thumbnail": "zzhc"
    },
    "2": {
        "title": "【雑兵】快楽堕ち",
        "pictures": ["HCX1", "HCX2", "HCX3", "HCX4", "HCX5", "HCX6", "HCX7", "HCX8", "HCX9"],
        "common_event_id": 29,
        "switch_id": 129,
        "thumbnail": "zzhcx"
    },
    "3": {
        "title": "贖罪",
        "pictures": ["HP1", "HP2", "HP3", "HP4", "HP5", "HP6", "HP7", "HP8", "HP9", "HP10", "HP11", "HP12", "HP13"],
        "common_event_id": 34,
        "switch_id": 134,
        "thumbnail": "zzhp"
        },
        "4": {
        "title": "贖罪・堕",
        "pictures": ["HPX1", "HPX2", "HPX3", "HPX4", "HPX5", "HPX6", "HPX7", "HPX8", "HPX9", "HPX10", "HPX11", "HPX12", "HPX13", "HPX14"],
        "common_event_id": 35,
        "switch_id": 135,
        "thumbnail": "zzhpx"
        },
        "5": {
        "title": "【大将】敗北",
        "pictures": ["T1", "T2", "T3", "T4", "T5", "T6", "T7", "T8", "T9", "T10", "T11", "T12"],
        "common_event_id": 36,
        "switch_id": 136,
        "thumbnail": "zzt"
        },
        "6": {
        "title": "【大将】快楽堕ち",
        "pictures": ["TX1", "TX2", "TX3", "TX4", "TX5", "TX6", "TX7", "TX8", "TX9", "TX10"],
        "common_event_id": 37,
        "switch_id": 137,
        "thumbnail": "zztx"
        },
        "7": {
        "title": "【ゴブリン】敗北",
        "pictures": ["HGA1", "HGA2", "HGA3", "HGA4", "HGA5", "HGA6", "HGA7", "HGA8", "HGA9", "HGA10", "HGA11", "HGA12"],
        "common_event_id": 38,
        "switch_id": 138,
        "thumbnail": "zzhga"
        },
        "8": {
        "title": "【ゴブリン】快楽堕ち",
        "pictures": ["HGAX1", "HGAX2", "HGAX3", "HGAX4", "HGAX5", "HGAX6", "HGAX7", "HGAX8", "HGAX9", "HGAX10", "HGAX11", "HGAX12"],
        "common_event_id": 39,
        "switch_id": 139,
        "thumbnail": "zzhgax"
        },
        "9": {
        "title": "【オーク】敗北",
        "pictures": ["HO1", "HO2", "HO3A", "HO4A", "HO5A", "HO6A", "HO7A", "HO8A", "HO9A", "HO10A", "HO11A", "HO12A"],
        "common_event_id": 40,
        "switch_id": 140,
        "thumbnail": "zzho"
        },
        "10": {
        "title": "【オーク】快楽堕ち",
        "pictures": ["HOX1", "HOX2", "HOX3A", "HOX4A", "HOX5A", "HOX6A", "HOX7A", "HOX8A", "HOX9A", "HOX10A", "HOX11A", "HOX12A"],
        "common_event_id": 41,
        "switch_id": 141,
        "thumbnail": "zzhox"
        },
        "11": {
        "title": "【ミノタウロス】敗北",
        "pictures": ["MM1", "MM2", "MM3", "MM4", "MM5", "MM6", "MM7", "MM8", "MM9", "MM10", "MM11"],
        "common_event_id": 42,
        "switch_id": 142,
        "thumbnail": "zzmm"
        },
        "12": {
        "title": "【ミノタウロス】快楽堕ち",
        "pictures": ["MMX1", "MMX2", "MMX3", "MMX4", "MMX5", "MMX6", "MMX7", "MMX8", "MMX9", "MMX10", "MMX11"],
        "common_event_id": 43,
        "switch_id": 143,
        "thumbnail": "zzmmx"
        },
        "13": {
        "title": "【ミノタウロス】敗走",
        "pictures": ["SM1", "SM2", "SM3", "SM4", "SM5", "SM6"],
        "common_event_id": 44,
        "switch_id": 144,
        "thumbnail": "zzsm"
        },
        "14": {
        "title": "【ゴブリン】敗走",
        "pictures": ["HGP1", "HGP2", "HGP3", "HGP４", "HGP５", "HGP６"],
        "common_event_id": 45,
        "switch_id": 145,
        "thumbnail": "zzhgp"
        },
        "15": {
        "title": "【オーク】敗走",
        "pictures": ["SO1", "SO2", "SO3", "SO5", "SO8", "SO9"],
        "common_event_id": 46,
        "switch_id": 146,
        "thumbnail": "zzso"
        },
        "16": {
        "title": "【暗殺者】敗走",
        "pictures": ["SA1", "SA2", "SA3", "SA4", "SA5"],
        "common_event_id": 47,
        "switch_id": 147,
        "thumbnail": "zzsa"
        },
        "17": {
        "title": "【暗殺者】敗北",
        "pictures": ["HA1", "HA2", "HA3", "HA4", "HA5", "HA6", "HA7A", "HA8A", "HA9A", "HA10A", "HA11A", "HA12A", "HA13A", "HA14A", "HA15A", "HA16A", "HA17A"],
        "common_event_id": 48,
        "switch_id": 148,
        "thumbnail": "zzha"
        },
        "18": {
        "title": "【暗殺者】快楽堕ち",
        "pictures": ["HAX1", "HAX2", "HAX3", "HAX4", "HAX5A", "HAX6A", "HAX7A", "HAX8A", "HAX9A", "HAX11A", "HAX11A", "HAX12A", "HAX13A", "HAX14A", "HAX15A"],
        "common_event_id": 49,
        "switch_id": 149,
        "thumbnail": "zzhax"
        },
        "19": {
        "title": "【人狼】敗走",
        "pictures": ["WS1", "WS2", "WS3", "WS4", "WS5", "WS6"],
        "common_event_id": 50,
        "switch_id": 150,
        "thumbnail": "zzws"
        },
        "20": {
        "title": "【人狼】敗北",
        "pictures": ["WH1", "WH2", "WH3", "WH4", "WH5", "WH6", "WH7", "WH8", "WH9", "WH10", "WH11"],
        "common_event_id": 51,
        "switch_id": 151,
        "thumbnail": "zzwh"
        },
        "21": {
        "title": "【人狼】敗走",
        "pictures": ["WHX1", "WHX2", "WHX3", "WHX4", "WHX5", "WHX6", "WHX7", "WHX8", "WHX9", "WHX10", "WHX11", "WHX12"],
        "common_event_id": 52,
        "switch_id": 152,
        "thumbnail": "zzwhx"
        },
        "22": {
        "title": "【触手】敗走",
        "pictures": ["S1", "S2", "S3", "S4", "S5", "S6", "S7", "S8", "S9"],
        "common_event_id": 53,
        "switch_id": 153,
        "thumbnail": "zzs"
        },
        "23": {
        "title": "【触手】敗北",
        "pictures": ["SS1", "SS2", "SS3", "SS4", "SS5", "SS6", "SS7", "SS8", "SS9", "SS10", "SS11"],
        "common_event_id": 54,
        "switch_id": 154,
        "thumbnail": "zzss"
        },
        "24": {
        "title": "【触手】快楽堕ち",
        "pictures": ["SSX1", "SSX2", "SSX3", "SSX4", "SSX5", "SSX6", "SSX7", "SSX8", "SSX9", "SSX10", "SSX11"],
        "common_event_id": 55,
        "switch_id": 155,
        "thumbnail": "zzssx"
        },
        "25": {
        "title": "【ネクロマンサー】敗走",
        "pictures": ["SW1", "SW2", "SW3", "SW4", "SW5", "SW6"],
        "common_event_id": 56,
        "switch_id": 156,
        "thumbnail": "zzsw"
        },
        "26": {
        "title": "【ネクロマンサー】敗北",
        "pictures": ["HW1", "HW2", "HW3A", "HW4A", "HW5A", "HW6A", "HW7A", "HW8A", "HW9A", "HW10A", "HW11A", "HW12A"],
        "common_event_id": 57,
        "switch_id": 157,
        "thumbnail": "zzhw"
        },
        "27": {
        "title": "【ネクロマンサー】快楽堕ち",
        "pictures": ["HWX1", "HWX2A", "HWX3A", "HWX4A", "HWX5A", "HWX6A", "HWX7A", "HWX8A", "HWX9A", "HWX10A", "HWX11A"],
        "common_event_id": 58,
        "switch_id": 158,
        "thumbnail": "zzhwx"
        },
        "28": {
        "title": "【ゴーレム】敗走",
        "pictures": ["SG1", "SG2", "SG3", "SG4", "SG5", "SG6"],
        "common_event_id": 59,
        "switch_id": 159,
        "thumbnail": "zzsg"
        },
        "29": {
        "title": "【ゴーレム】敗北",
        "pictures": ["HGL1", "HGL2", "HGL3", "HGL4", "HGL5", "HGL6", "HGL7", "HGL8", "HGL9", "HGL10", "HGL11"],
        "common_event_id": 60,
        "switch_id": 160,
        "thumbnail": "zzhgl"
        },
        "30": {
        "title": "【ゴーレム】快楽堕ち",
        "pictures": ["HGX1", "HGX2", "HGX3", "HGX4", "HGX5", "HGX6", "HGX7", "HGX8", "HGX9", "HGX10"],
        "common_event_id": 61,
        "switch_id": 161,
        "thumbnail": "zzhgx"
        },
        "31": {
        "title": "【ゴブリン】零落",
        "pictures": ["GX1", "GX2", "GX3", "GX4", "GX5", "GX6", "GX7", "GX8", "GX9", "GX10", "GX11", "GX12", "GX13"],
        "common_event_id": 62,
        "switch_id": 162,
        "thumbnail": "zzgx"
        },
        "32": {
        "title": "【魔王】敗走",
        "pictures": ["SB1", "SB2", "SB3", "SB4", "SB5", "SB6"],
        "common_event_id": 63,
        "switch_id": 163,
        "thumbnail": "zzsb"
        },
        "33": {
        "title": "【魔王】主への奉仕",
        "pictures": ["P1", "P2", "P3", "P4", "P5", "P6", "P7", "P8", "P9", "P10"],
        "common_event_id": 64,
        "switch_id": 164,
        "thumbnail": "zzp"
        },
        "34": {
        "title": "【魔王】交わり",
        "pictures": ["HB1", "HB2", "HB3", "HB4", "HB5", "HB6", "HB7", "HB8", "HB9", "HB10"],
        "common_event_id": 65,
        "switch_id": 165,
        "thumbnail": "zzhb"
        },
        "35": {
        "title": "【魔王】交わり（堕）",
        "pictures": ["HBX1", "HBX2", "HBX3", "HBX4", "HBX5", "HBX6", "HBX7", "HBX8", "HBX9", "HBX10", "HBX11"],
        "common_event_id": 66,
        "switch_id": 166,
        "thumbnail": "zzhbx"
        },
        "36": {
        "title": "【ヴァイパー】敗走",
        "pictures": ["H1", "H2", "H3", "H4", "H5", "H6", "H7", "H8"],
        "common_event_id": 67,
        "switch_id": 167,
        "thumbnail": "zzh"
        },
        "37": {
        "title": "【複数】敗北",
        "pictures": ["HSB1", "HSB2", "HSB3", "HSB4", "HSB5", "HSB6", "HSB7", "HSB8", "HSB9", "HSB10"],
        "common_event_id": 68,
        "switch_id": 168,
        "thumbnail": "zzhsb"
        },
        "38": {
        "title": "【複数】敗北（堕）",
        "pictures": ["HSBX1", "HSBX2", "HSBX3", "HSBX4", "HSBX5", "HSBX6", "HSBX7", "HSBX8", "HSBX9", "HSBX10", "HSBX11"],
        "common_event_id": 69,
        "switch_id": 169,
        "thumbnail": "zzhsbx"
        },
        "39": {
        "title": "魔物化",
        "pictures": ["MS1", "MS2", "MS3", "MS4", "MS5", "MS6", "MS7", "MS8", "MS9"],
        "common_event_id": 70,
        "switch_id": 170,
        "thumbnail": "zzms"
        },
        "40": {
        "title": "【ヴァイパー】黒い影",
        "pictures": ["ESM1", "ESM2", "ESM3", "ESM4", "ESM5", "ESM6", "ESM7", "ESM8", "ESM9", "ESM10"],
        "common_event_id": 71,
        "switch_id": 171,
        "thumbnail": "zzesm"
        },
         "41": {
            "title": "【ヴァイパー】手淫",
            "pictures": ["TS1", "TS2", "TS3", "TS4", "TS5"],
            "common_event_id": 73,
            "switch_id": 173,
            "thumbnail": "zzts"
            },
            "42": {
            "title": "霞",
            "pictures": ["HY1", "HY2", "HY3", "HY4", "HY5", "HY6", "HY7", "HY8", "HY9", "HY10", "HY11A", "HY12A", "HY13A"],
            "common_event_id": 74,
            "switch_id": 174,
            "thumbnail": "zzhy"
            },
            "43": {
            "title": "【雪の王】宣言",
            "pictures": ["HK1", "HK2", "HK3", "HK4", "HK5", "HK6", "HK7", "HK8", "HK9", "HK10", "HK11", "HK12"],
            "common_event_id": 75,
            "switch_id": 175,
            "thumbnail": "zzhk"
            },
            "44": {
            "title": "【エリン】安堵",
            "pictures": ["HSS1", "HSS2A", "HSS3A", "HSS4A", "HSS5A", "HSS6A", "HSS7A"],
            "common_event_id": 76,
            "switch_id": 176,
            "thumbnail": "zzhss"
            },
            "45": {
            "title": "【ヴァイパー】口淫",
            "pictures": ["SF1", "SF2", "SF3", "SF4", "SF5", "SF6", "SF7", "SF8", "SF9", "SF10", "SF11", "SF12", "SF13", "SF14"],
            "common_event_id": 77,
            "switch_id": 177,
            "thumbnail": "zzsf"
            },
            "46": {
            "title": "【ヴァイパー】紊乱",
            "pictures": ["R1", "R2", "R3", "R4", "R5", "R6", "R7", "R8", "R9", "R10", "R11"],
            "common_event_id": 78,
            "switch_id": 178,
            "thumbnail": "zzr"
            },
            "47": {
            "title": "【エリン】大浴場",
            "pictures": ["HST1", "HST2", "HST3", "HST4", "HST5", "HST6", "HST7"],
            "common_event_id": 79,
            "switch_id": 179,
            "thumbnail": "zzhst"
            },
            "48": {
            "title": "【ラットゥス】素股（堕）",
            "pictures": ["BX1", "BX2", "BX3", "BX4", "BX5", "BX6", "BX7", "BX8", "BX9", "BX10", "BX11"],
            "common_event_id": 80,
            "switch_id": 180,
            "thumbnail": "zzbx"
            },
            "49": {
            "title": "【ラットゥス】素股",
            "pictures": ["B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "B10", "B11", "B12"],
            "common_event_id": 81,
            "switch_id": 181,
            "thumbnail": "zzb"
            },
            "50": {
            "title": "【ラットゥス】扇情",
            "pictures": ["K1", "K2", "K3", "K4", "K5", "K6", "K7", "K8", "K9", "K10", "K11", "K12"],
            "common_event_id": 82,
            "switch_id": 182,
            "thumbnail": "zzk"
            },
            "51": {
                "title": "虚実皮膜",
                "pictures": ["F1", "F2", "F3", "F4", "F5", "F6"],
                "common_event_id": 84,
                "switch_id": 184,
                "thumbnail": "zzf"
                },
                "52": {
                "title": "【娼館】複数",
                "pictures": ["HHKB1", "HHKB2", "HHKB3", "HHKB4", "HHKB5", "HHKB6", "HHKB7", "HHKB8", "HHKB9", "HHKB10", "HHKB11", "HHKB12"],
                "common_event_id": 85,
                "switch_id": 185,
                "thumbnail": "zzhhkb"
                },
                "53": {
                "title": "【娼館】複数・淫",
                "pictures": ["HHKBX1", "HHKBX2", "HHKBX3", "HHKBX4", "HHKBX5", "HHKBX6", "HHKBX7", "HHKBX8", "HHKBX9", "HHKBX10", "HHKBX11", "HHKBX12", "HHKBX13"],
                "common_event_id": 86,
                "switch_id": 186,
                "thumbnail": "zzhhkbx"
                },
                "54": {
                "title": "【娼館】中年",
                "pictures": ["HHK1", "HHK2", "HHK3", "HHK4", "HHK5", "HHK6", "HHK7", "HHK8", "HHK9", "HHK10", "HHK11"],
                "common_event_id": 87,
                "switch_id": 187,
                "thumbnail": "zzhhk"
                },
                "55": {
                "title": "【娼館】中年・淫",
                "pictures": ["HHKX1", "HHKX2", "HHKX3", "HHKX4", "HHKX5", "HHKX6", "HHKX7", "HHKX8", "HHKX9", "HHKX10"],
                "common_event_id": 88,
                "switch_id": 188,
                "thumbnail": "zzhhkx"
                },
                "56": {
                "title": "【娼館】オーク",
                "pictures": ["HKO1", "HKO2", "HKO3", "HKO4", "HKO5", "HKO6", "HKO7", "HKO8", "HKO9", "HKO10"],
                "common_event_id": 89,
                "switch_id": 189,
                "thumbnail": "zzhko"
                },
                "57": {
                "title": "【娼館】オーク・淫",
                "pictures": ["HKOX1", "HKOX2", "HKOX3", "HKOX4", "HKOX5", "HKOX6", "HKOX7", "HKOX8", "HKOX9", "HKOX10"],
                "common_event_id": 90,
                "switch_id": 190,
                "thumbnail": "zzhkox"
                },
                "58": {
                "title": "淫紋",
                "pictures": ["HI1", "HI2", "HI3", "HI4", "HI5", "HI6", "HI7", "HI8"],
                "common_event_id": 91,
                "switch_id": 191,
                "thumbnail": "zzhi"
                },
                "59": {
                "title": "淫紋・堕",
                "pictures": ["HIX1", "HIX2", "HIX3", "HIX4", "HIX5", "HIX6", "HIX7", "HIX8", "HIX9", "HIX10"],
                "common_event_id": 92,
                "switch_id": 192,
                "thumbnail": "zzhix"
                },
                "60": {
                    "title": "【ラットゥス】癖",
                    "pictures": ["HKA1", "HKA2", "HKA3", "HKA4", "HKA5", "HKA6", "HKA7", "HKA8", "HKA9", "HKA10", "HKA11"],
                    "common_event_id": 94,
                    "switch_id": 194,
                    "thumbnail": "zzhka"
                    },
                    "61": {
                    "title": "【ラットゥス】癖・堕",
                    "pictures": ["HKAX1", "HKAX2", "HKAX3", "HKAX4", "HKAX5", "HKAX6", "HKAX7", "HKAX8", "HKAX9", "HKAX10", "HKAX13"],
                    "common_event_id": 95,
                    "switch_id": 195,
                    "thumbnail": "zzhkax"
                    },
                    "62": {
                        "title": "【ヴァイパー】禁忌",
                        "pictures": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10"],
                        "common_event_id": 72,
                        "switch_id": 172,
                        "thumbnail": "zz1"
                        },
                        "63": {
                            "title": "瘴気",
                            "pictures": ["GM1", "GM2", "GM3", "GM4", "GM5", "GM6", "GM7", "GM8", "GM9", "GM10", "GM11", "GM12", "GM13", "GM14"],
                            "common_event_id": 96,
                            "switch_id": 196,
                            "thumbnail": "zzgm"
                            },
                            "64": {
                            "title": "瘴気・堕",
                            "pictures": ["GMX1", "GMX2", "GMX3", "GMX4", "GMX5", "GMX6", "GMX7", "GMX8", "GMX9", "GMX10", "GMX11", "GMX12", "GMX13", "GMX14", "GMX15"],
                            "common_event_id": 97,
                            "switch_id": 197,
                            "thumbnail": "zzgmx"
                            },
                            "65": {
                            "title": "【ゴブリン】奇襲",
                            "pictures": ["G1", "G2", "G3", "G4", "G5", "G6", "G7", "G8", "G9"],
                            "common_event_id": 98,
                            "switch_id": 198,
                            "thumbnail": "zzg"
                            },
                            "66": {
                                "title": "誓い",
                                "pictures": ["M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10"],
                                "common_event_id": 101,
                                "switch_id": 201,
                                "thumbnail": "zzm"
                                },
                            "67": {
                            "title": "自慰・淫",
                            "pictures": ["HJB1", "HJB2", "HJB3", "HJB4"],
                            "common_event_id": 99,
                            "switch_id": 199,
                            "thumbnail": "zzhjb"
                            },
                            "68": {
                            "title": "自慰",
                            "pictures": ["O1", "O2", "O3", "O4", "O5"],
                            "common_event_id": 100,
                            "switch_id": 200,
                            "thumbnail": "zzo"
                            },

                            "69": {
                            "title": "出産",
                            "pictures": ["ABH1", "ABH2", "ABH3", "ABH4", "ABH5"],
                            "common_event_id": 111,
                            "switch_id": 301,
                            "thumbnail": "ABH5"
                            },
                            "70": {
                            "title": "出産・ゴブリン",
                            "pictures": ["BG1", "BG2", "BG3", "BG4", "BG5"],
                            "common_event_id": 112,
                            "switch_id": 302,
                            "thumbnail": "BG5"
                            },
                            "71": {
                            "title": "出産・オーク",
                            "pictures": ["BG1", "BO2", "BO3", "BO4", "BO5"],
                            "common_event_id": 113,
                            "switch_id": 303,
                            "thumbnail": "BO5"
                            },
                            "72": {
                            "title": "出産・ミノタウロス",
                            "pictures": ["BG1", "BM2", "BM3", "BM4", "BM5"],
                            "common_event_id": 114,
                            "switch_id": 304,
                            "thumbnail": "BM5"
                            },
                            "73": {
                            "title": "出産・ワーウルフ",
                            "pictures": ["BG1", "BW3", "BW4", "BW5"],
                            "common_event_id": 115,
                            "switch_id": 305,
                            "thumbnail": "BW5"
                            },
                            "74": {
                            "title": "出産・大将",
                            "pictures": ["ABH1", "ABH2", "ABH3", "ABH4", "ABH5"],
                            "common_event_id": 116,
                            "switch_id": 306,
                            "thumbnail": "ABH5"
                            },
                            "75": {
                            "title": "出産・雪の王",
                            "pictures": ["ABH1", "ABH2", "ABH3", "ABH4", "ABH5"],
                            "common_event_id": 117,
                            "switch_id": 307,
                            "thumbnail": "ABH5"
                            },
                            "76": {
                            "title": "出産・王子",
                            "pictures":["ABH1", "ABH2", "ABH3", "ABH4", "ABH5"],
                            "common_event_id": 118,
                            "switch_id": 308,
                            "thumbnail": "ABH5"
                            },
                            "77": {
                            "title": "出産・触手",
                            "pictures": ["ABS1", "ABS2", "ABS3", "ABS4", "ABS5"],
                            "common_event_id": 119,
                            "switch_id": 309,
                            "thumbnail": "ABS5"
                            },
                            "78": {
                            "title": "出産・ネクロ",
                            "pictures": ["BG1", "BN2", "BN3", "BN4", "BN5"],
                            "common_event_id": 120,
                            "switch_id": 310,
                            "thumbnail": "BN5"
                             },

},
    //---------------------------------------------------------------------
    // ★ 回想時に一時的に利用するマップIDを指定します
    //---------------------------------------------------------------------
    // 通常は何もないマップを指定します
    //---------------------------------------------------------------------
    "sandbox_map_id": 1,
    //---------------------------------------------------------------------
    // ★ 回想用スイッチをセーブデータ間で共有するかどうかを指定します
    //---------------------------------------------------------------------
    // パラメータの説明
    // true:
    //      回想用スイッチを共有します。
    //
    //      例1：セーブ1で回想スイッチ1, 2, 3がONとする
    //          ニューゲームで開始し、セーブ1を上書きする
    //          →セーブ1の回想スイッチ1, 2, 3はONのままとなる。
    //
    //      例2: セーブ1で回想スイッチ1, 2, 3がONとする
    //          セーブ1をロードし、セーブ2を保存する
    //          セーブ2で回想スイッチ1, 2, 3, 7がONとする
    //          セーブ1, セーブ2それぞれで、回想スイッチ1, 2, 3, 7がONとなる
    //
    // false:
    //      回想用スイッチを共有しません
    //
    // すべてのセーブデータを削除した場合にのみ、スイッチがリセットされます
    //---------------------------------------------------------------------
    "share_recollection_switches": true
};

function rngd_hash_size(obj) {
    var cnt = 0;
    for(var o in obj) {
        cnt++;
    }
    return cnt;
}

//-----------------------------------------------------------------------------
// ◆ Scene関数
//-----------------------------------------------------------------------------

//=========================================================================
// ■ Scene_Recollection
//=========================================================================
// 回想用のシーン関数です
//=========================================================================
function Scene_Recollection() {
    this.initialize.apply(this, arguments);
}

Scene_Recollection.prototype = Object.create(Scene_Base.prototype);
Scene_Recollection.prototype.constructor = Scene_Recollection;

Scene_Recollection.prototype.initialize = function() {
    Scene_Base.prototype.initialize.call(this);
};

Scene_Recollection.prototype.create = function() {
    Scene_Base.prototype.create.call(this);
    this.createWindowLayer();
    this.createCommandWindow();
};

// 回想モードのカーソル
Scene_Recollection.rec_list_index = 0;

// 回想モードの再読み込み判定用 true: コマンドウィンドウを表示せず回想リストを表示 false:コマンドウィンドウを表示
Scene_Recollection.reload_rec_list = false;

Scene_Recollection.prototype.createCommandWindow = function() {

    if(Scene_Recollection.reload_rec_list) {
        // 回想モード選択ウィンドウ
        this._rec_window = new Window_RecollectionCommand();
        this._rec_window.setHandler('select_recollection', this.commandShowRecollection.bind(this));
        this._rec_window.setHandler('select_cg', this.commandShowCg.bind(this));
        this._rec_window.setHandler('select_back_title', this.commandBackTitle.bind(this));

        // リロードの場合：選択ウィンドウを非表示にする
        this._rec_window.visible = false;
        this._rec_window.deactivate();
        this.addWindow(this._rec_window);

        // 回想リスト
        this._rec_list = new Window_RecList(0, 0, Graphics.width, Graphics.height);

        // リロードの場合：回想リストを表示にする
        this._rec_list.visible = true;
        this._rec_list.setHandler('ok', this.commandDoRecMode.bind(this));
        this._rec_list.setHandler('cancel', this.commandBackSelectMode.bind(this));
        this._mode = "recollection";
        this._rec_list.activate();
        this._rec_list.select(Scene_Recollection.rec_list_index);

        this.addWindow(this._rec_list);

        // CG参照用ダミーコマンド
        this._dummy_window = new Window_Command(0, 0);
        this._dummy_window.deactivate();
        this._dummy_window.visible = false;
        this._dummy_window.setHandler('ok', this.commandDummyOk.bind(this));
        this._dummy_window.setHandler('cancel', this.commandDummyCancel.bind(this));
        this._dummy_window.addCommand('next', 'ok');
        this.addWindow(this._dummy_window);

        Scene_Recollection.reload_rec_list = false;

    } else {
        // 回想モード選択ウィンドウ
        this._rec_window = new Window_RecollectionCommand();
        this._rec_window.setHandler('select_recollection', this.commandShowRecollection.bind(this));
        this._rec_window.setHandler('select_cg', this.commandShowCg.bind(this));
        this._rec_window.setHandler('select_back_title', this.commandBackTitle.bind(this));
        this.addWindow(this._rec_window);

        // 回想リスト
        this._rec_list = new Window_RecList(0, 0, Graphics.width, Graphics.height);
        this._rec_list.visible = false;
        this._rec_list.setHandler('ok', this.commandDoRecMode.bind(this));
        this._rec_list.setHandler('cancel', this.commandBackSelectMode.bind(this));
        this._rec_list.select(Scene_Recollection.rec_list_index);
        this.addWindow(this._rec_list);

        // CG参照用ダミーコマンド
        this._dummy_window = new Window_Command(0, 0);
        this._dummy_window.deactivate();
        this._dummy_window.playOkSound = function(){}; // CGﾓｰﾄﾞの場合、OK音を鳴らさない
        this._dummy_window.visible = false;
        this._dummy_window.setHandler('ok', this.commandDummyOk.bind(this));
        this._dummy_window.setHandler('cancel', this.commandDummyCancel.bind(this));
        this._dummy_window.addCommand('next', 'ok');
        this.addWindow(this._dummy_window);
    }

};

//-------------------------------------------------------------------------
// ● 開始処理
//-------------------------------------------------------------------------
Scene_Recollection.prototype.start = function() {
    Scene_Base.prototype.start.call(this);
    this._rec_window.refresh();
    this._rec_list.refresh();
    AudioManager.playBgm(rngd_recollection_mode_settings.rec_mode_bgm.bgm);
    Scene_Recollection._rngd_recollection_doing = false;
};

//-------------------------------------------------------------------------
// ● 更新処理
//-------------------------------------------------------------------------
Scene_Recollection.prototype.update = function() {
    Scene_Base.prototype.update.call(this);

};

//-------------------------------------------------------------------------
// ● 「回想を見る」を選択した際のコマンド
//-------------------------------------------------------------------------
Scene_Recollection.prototype.commandShowRecollection = function() {
    // モードウィンドウの無効化とリストウィンドウの有効化
    this.do_exchange_status_window(this._rec_window, this._rec_list);
    this._mode = "recollection";
};

//-------------------------------------------------------------------------
// ● 「CGを見る」を選択した際のコマンド
//-------------------------------------------------------------------------
Scene_Recollection.prototype.commandShowCg = function() {
    this.do_exchange_status_window(this._rec_window, this._rec_list);
    this._mode = "cg";
};

//-------------------------------------------------------------------------
// ● 「タイトルに戻る」を選択した際のコマンド
//-------------------------------------------------------------------------
Scene_Recollection.prototype.commandBackTitle = function() {
    Scene_Recollection.rec_list_index = 0;
    SceneManager.goto(Scene_Title);
};

//-------------------------------------------------------------------------
// ● 回想orCGモードから「キャンセル」して前の画面に戻った場合のコマンド
//-------------------------------------------------------------------------
Scene_Recollection.prototype.commandBackSelectMode = function() {
    this.do_exchange_status_window(this._rec_list, this._rec_window);
};

//-------------------------------------------------------------------------
// ● 回想orCGモードにおいて、実際の回想orCGを選択した場合のコマンド
//-------------------------------------------------------------------------
// フラグ追加
Scene_Recollection.recollection_event_playing = false;

Scene_Recollection.prototype.commandDoRecMode = function() {
    var target_index = this._rec_list.index() + 1;
    Scene_Recollection.rec_list_index = target_index - 1;

    if (this._rec_list.is_valid_picture(this._rec_list.index() + 1)) {
        // 回想モードの場合
        if (this._mode === "recollection") {
            Scene_Recollection._rngd_recollection_doing = true;
            Scene_Recollection.recollection_event_playing = true;  // フラグを設定

            $gamePlayer.setTransparent(255);
            this.fadeOutAll();
            $gameTemp.reserveCommonEvent(rngd_recollection_mode_settings.rec_cg_set[target_index]["common_event_id"]);
            $gamePlayer.reserveTransfer(rngd_recollection_mode_settings.sandbox_map_id, 0, 0, 0);
            Graphics.frameCount = 0;
            SceneManager.push(Scene_Map);

            console.log("Reserved common event: " + rngd_recollection_mode_settings.rec_cg_set[target_index]["common_event_id"]);
        // CGモードの場合
        } else if (this._mode === "cg") {
            this._cg_sprites = [];
            this._cg_sprites_index = 0;

            // シーン画像をロードする
            rngd_recollection_mode_settings.rec_cg_set[target_index].pictures.forEach(function (name) {
                var sp = new Sprite_Button();
                sp.setClickHandler(this.commandDummyOk.bind(this));
                sp.processTouch = function() {
                    Sprite_Button.prototype.processTouch.call(this);
                };
                sp.bitmap = ImageManager.loadPicture(name);
                if (this._cg_sprites.length > 0) {
                    sp.visible = false;
                }
                this._cg_sprites.push(sp);
                this.addChild(sp);
            }, this);

            this.do_exchange_status_window(this._rec_list, this._dummy_window);
            this._dummy_window.visible = false;
        }
    } else {
        this._rec_list.activate();
    }
};

Scene_Recollection.prototype.commandDummyOk = function() {

    if(this._cg_sprites_index < this._cg_sprites.length - 1) {
        this._cg_sprites[this._cg_sprites_index].visible = false;
        this._cg_sprites_index++;
        this._cg_sprites[this._cg_sprites_index].visible = true;
        SoundManager.playOk();

        this._dummy_window.activate();
    } else {
        SoundManager.playOk();
        this.commandDummyCancel();
    }
};

Scene_Recollection.prototype.commandDummyCancel = function() {
    this._cg_sprites.forEach(function(obj) {
        obj.visible = false;
        obj = null;
    });
    this.do_exchange_status_window(this._dummy_window, this._rec_list);
};

// コモンイベントから呼び出す関数
Scene_Recollection.prototype.rngd_exit_scene = function() {
    if(Scene_Recollection._rngd_recollection_doing) {
        // Window_RecListを表示する
        Scene_Recollection.reload_rec_list = true;
        SceneManager.goto(Scene_Recollection);
    }
};

//-------------------------------------------------------------------------
// ● ウィンドウの無効化と有効化
//-------------------------------------------------------------------------
// win1: 無効化するウィンドウ
// win2: 有効化するウィンドウ
//-------------------------------------------------------------------------
Scene_Recollection.prototype.do_exchange_status_window = function(win1, win2) {
    win1.deactivate();
    win1.visible = false;
    win2.activate();
    win2.visible = true;
};
//-------------------------------------------------------------------------
// ● セーブ・ロード・ニューゲーム時に必要なスイッチをONにする
//-------------------------------------------------------------------------
Scene_Recollection.setRecollectionSwitches = function() {
    // 各セーブデータを参照し、RecollectionMode用のスイッチを検索する
    // スイッチが一つでもONになっている場合は回想をONにする
    for(var i = 1; i <= DataManager.maxSavefiles(); i++) {
        var data = null;
        try {
            data = StorageManager.loadFromLocalFile(i);
        } catch(e) {
            data = StorageManager.loadFromWebStorage(i);
        }
        if(data) {
            var save_data_obj = JsonEx.parse(data);
            var rec_cg_max = rngd_hash_size(rngd_recollection_mode_settings.rec_cg_set);

            for(var j = 0; j < rec_cg_max; j++) {
                var cg = rngd_recollection_mode_settings.rec_cg_set[j+1];
                if(save_data_obj["switches"]._data[cg.switch_id] &&
                    save_data_obj["switches"]._data[cg.switch_id] == true) {
                    $gameSwitches.setValue(cg.switch_id, true);
                }
            }
        }
    }
};

//-----------------------------------------------------------------------------
// ◆ Window関数
//-----------------------------------------------------------------------------

//=========================================================================
// ■ Window_RecollectionCommand
//=========================================================================
// 回想モードかCGモードを選択するウィンドウです
//=========================================================================
function Window_RecollectionCommand() {
    this.initialize.apply(this, arguments);
}

Window_RecollectionCommand.prototype = Object.create(Window_Command.prototype);
Window_RecollectionCommand.prototype.constructor = Window_RecollectionCommand;

Window_RecollectionCommand.prototype.initialize = function() {
    Window_Command.prototype.initialize.call(this, 0, 0);
    this.x = rngd_recollection_mode_settings.rec_mode_window.x;
    this.y = rngd_recollection_mode_settings.rec_mode_window.y;

};

Window_RecollectionCommand.prototype.makeCommandList = function() {
    Window_Command.prototype.makeCommandList.call(this);
    this.addCommand(rngd_recollection_mode_settings.rec_mode_window.str_select_recollection, "select_recollection");
    this.addCommand(rngd_recollection_mode_settings.rec_mode_window.str_select_cg, "select_cg");
    this.addCommand(rngd_recollection_mode_settings.rec_mode_window.str_select_back_title, "select_back_title");
};

//=========================================================================
// ■ Window_RecollectionList
//=========================================================================
// 回想またはCGを選択するウィンドウです
//=========================================================================
function Window_RecList() {
    this.initialize.apply(this, arguments);
}

Window_RecList.prototype = Object.create(Window_Selectable.prototype);
Window_RecList.prototype.constructor = Window_RecList;

//-------------------------------------------------------------------------
// ● 初期化処理
//-------------------------------------------------------------------------
Window_RecList.prototype.initialize = function(x, y, width, height) {
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this.windowWidth = width;
    this.windowHeight = height;
    this.select(0);
    this._formationMode = false;
    this.get_global_variables();
    this.refresh();

};

Window_RecList.prototype.maxItems = function() {
    return rngd_hash_size(rngd_recollection_mode_settings.rec_cg_set);
};

Window_RecList.prototype.itemHeight = function() {
    return (this.height - this.standardPadding()) / rngd_recollection_mode_settings.rec_list_window.item_height;
};

Window_RecList.prototype.maxPageItems = function() {
    return rngd_hash_size(rngd_recollection_mode_settings.rec_cg_set);
};

Window_RecList.prototype.maxCols = function() {
    return rngd_recollection_mode_settings.rec_list_window.item_width;
};

Window_RecList.prototype.maxPageRows = function() {
    var pageHeight = this.height;// - this.padding * 2;
    return Math.floor(pageHeight / this.itemHeight());
};

Window_RecList.prototype.drawItem = function(index) {
    var rec_cg = rngd_recollection_mode_settings.rec_cg_set[index+1];
    var rect = this.itemRect(index);
    var text_height = 0;
    if(rngd_recollection_mode_settings.rec_list_window.show_title_text) {
        if(this._global_variables["switches"][rec_cg.switch_id]) {
            this.contents.drawText(rec_cg.title, rect.x + 4, rect.y + 4, this.itemWidth(), 32,
                rngd_recollection_mode_settings.rec_list_window.title_text_align);
        } else {
            this.contents.drawText(rngd_recollection_mode_settings.rec_list_window.never_watch_title_text,
                rect.x + 4, rect.y + 4, this.itemWidth(), 32,
                rngd_recollection_mode_settings.rec_list_window.title_text_align);
        }
        text_height = 32;
    }

    // CGセットのスイッチ番号が、全てのセーブデータを走査した後にTrueであればピクチャ表示
    if(this._global_variables["switches"][rec_cg.switch_id]) {

        var thumbnail_file_name = rec_cg.pictures[0];
        if(rec_cg.thumbnail !== undefined && rec_cg.thumbnail !== null) {
            thumbnail_file_name = rec_cg.thumbnail;
        }

        var thumbnail = ImageManager.loadPicture(thumbnail_file_name);
        var bitmap = new Bitmap(this.itemWidth() - 36, this.itemHeight() - 8 - text_height);
        var width = thumbnail.width;
        var height = thumbnail.height;
        var scale = Math.min((this.itemWidth() - 36) / width, (this.itemHeight() - 8 - text_height) / height);
        width *= scale;
        height *= scale;
        bitmap.blt(thumbnail, 0, 0, thumbnail.width, thumbnail.height, (this.itemWidth() - 36 - width) / 2, (this.itemHeight() - 8 - text_height - height) / 2, width, height);
        this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, rect.x + 16, rect.y + 4 + text_height);

    } else {
        this.drawRecollection(rngd_recollection_mode_settings.rec_list_window.never_watch_picture_name,
                0, 0 , this.itemWidth() - 36,
                this.itemHeight() - 8 - text_height, rect.x + 16, rect.y + 4 + text_height);

    }

};

//-------------------------------------------------------------------------
// ● 全てのセーブデータを走査し、対象のシーンスイッチ情報を取得する
//-------------------------------------------------------------------------
Window_RecList.prototype.get_global_variables = function() {
    this._global_variables = {
        "switches": {}
    };
    var maxSaveFiles = DataManager.maxSavefiles();
    for(var i = 1; i <= maxSaveFiles; i++) {
        if(DataManager.loadGameSwitch(i)) {
            var rec_cg_max = rngd_hash_size(rngd_recollection_mode_settings.rec_cg_set);

            for(var j = 0; j < rec_cg_max; j++) {
                var cg = rngd_recollection_mode_settings.rec_cg_set[j+1];
                if($gameSwitches._data[cg.switch_id]) {
                    this._global_variables["switches"][cg.switch_id] = true;
                }
            }
        }
    }
};
//-------------------------------------------------------------------------
// ● index番目に表示された回想orCGが有効かどうか判断する
//-------------------------------------------------------------------------
Window_RecList.prototype.is_valid_picture = function(index) {
    // CG情報の取得と対象スイッチの取得
    var _rec_cg_obj = rngd_recollection_mode_settings.rec_cg_set[index];
    return ( this._global_variables["switches"][_rec_cg_obj.switch_id] == true);

};


(function(){

//-----------------------------------------------------------------------------
// ◆ 組み込み関数Fix
//-----------------------------------------------------------------------------

Window_Base.prototype.drawRecollection = function(bmp_name, x, y, width, height, dx, dy) {
    var bmp = ImageManager.loadPicture(bmp_name);

    var _width = width;
    var _height = height;
    if(_width > bmp.width) {
        _width = bmp.width - 1;
    }

    if(_height > bmp.height) {
        _height = bmp.height - 1;
    }
    this.contents.blt(bmp, x, y, _width, _height, dx, dy);
};

var Window_TitleCommand_makeCommandList =
    Window_TitleCommand.prototype.makeCommandList;

Window_TitleCommand.prototype.makeCommandList = function() {
    Window_TitleCommand_makeCommandList.call(this);
    this.clearCommandList();
    this.addCommand(TextManager.newGame,   'newGame');
    this.addCommand(TextManager.continue_, 'continue', this.isContinueEnabled());
    this.addCommand(rngd_recollection_mode_settings.rec_mode_window.recollection_title, 'recollection');
    this.addCommand(TextManager.options,   'options');
};

Scene_Title.prototype.commandRecollection = function() {
    SceneManager.push(Scene_Recollection);
};

var Scene_Title_createCommandWindow = Scene_Title.prototype.createCommandWindow;
Scene_Title.prototype.createCommandWindow = function() {
    Scene_Title_createCommandWindow.call(this);
    this._commandWindow.setHandler('recollection', this.commandRecollection.bind(this));
};

// セーブデータ共有オプションが指定されている場合のみ、カスタマイズ
if(rngd_recollection_mode_settings["share_recollection_switches"]) {
    DataManager.makeSaveContents = function() {
        // A save data does not contain $gameTemp, $gameMessage, and $gameTroop.

        Scene_Recollection.setRecollectionSwitches();

        var contents = {};
        contents.system       = $gameSystem;
        contents.screen       = $gameScreen;
        contents.timer        = $gameTimer;
        contents.switches     = $gameSwitches;
        contents.variables    = $gameVariables;
        contents.selfSwitches = $gameSelfSwitches;
        contents.actors       = $gameActors;
        contents.party        = $gameParty;
        contents.map          = $gameMap;
        contents.player       = $gamePlayer;

        return contents;
    };

    DataManager.extractSaveContents = function(contents) {
        $gameSystem        = contents.system;
        $gameScreen        = contents.screen;
        $gameTimer         = contents.timer;
        $gameSwitches      = contents.switches;
        $gameVariables     = contents.variables;
        $gameSelfSwitches  = contents.selfSwitches;
        $gameActors        = contents.actors;
        $gameParty         = contents.party;
        $gameMap           = contents.map;
        $gamePlayer        = contents.player;

        Scene_Recollection.setRecollectionSwitches();
    };

    DataManager.setupNewGame = function() {
        this.createGameObjects();
        Scene_Recollection.setRecollectionSwitches();
        this.selectSavefileForNewGame();
        $gameParty.setupStartingMembers();
        $gamePlayer.reserveTransfer($dataSystem.startMapId,
            $dataSystem.startX, $dataSystem.startY);
        Graphics.frameCount = 0;
    };
}

//-----------------------------------------------------------------------------
// ◆ DataManager関数
//-----------------------------------------------------------------------------

//-------------------------------------------------------------------------
// ● スイッチのみロードする
//-------------------------------------------------------------------------
DataManager.loadGameSwitch = function(savefileId) {
    try {
        return this.loadGameSwitchWithoutRescue(savefileId);
    } catch (e) {
        console.error(e);
        return false;
    }
};

DataManager.loadGameSwitchWithoutRescue = function(savefileId) {
    var globalInfo = this.loadGlobalInfo();
    if (this.isThisGameFile(savefileId)) {
        var json = StorageManager.load(savefileId);
        this.createGameObjectSwitch();
        this.extractSaveContentsSwitches(JsonEx.parse(json));
        //this._lastAccessedId = savefileId;
        return true;
    } else {
        return false;
    }
};

DataManager.createGameObjectSwitch = function() {
    $gameSwitches      = new Game_Switches();
};

DataManager.extractSaveContentsSwitches = function(contents) {
    $gameSwitches      = contents.switches;
};

})();